<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('significant_work_master', function (Blueprint $table) {
            $table->id('work_id');
            $table->string('work_code', 30)->unique();
            $table->string('work_name', 200);
            $table->string('work_category', 30)->nullable();
            $table->decimal('estimated_cost', 15, 2)->nullable();
            $table->string('status', 20)->default('PLANNED');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('significant_work_master');
    }
};
