<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('award_master', function (Blueprint $table) {
            $table->id('award_id');
            $table->string('award_code', 30)->unique();
            $table->string('award_name', 200);
            $table->integer('award_year')->nullable();
            $table->string('awarding_authority', 100)->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('award_master');
    }
};
