<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tax_type_master', function (Blueprint $table) {
            $table->id('tax_type_id');
            $table->string('tax_code', 20)->unique();
            $table->string('tax_name', 100);
            $table->decimal('tax_percentage', 5, 2)->default(0);
            $table->enum('frequency', ['MONTHLY', 'QUARTERLY', 'HALF_YEARLY', 'YEARLY'])->nullable();
            $table->string('calculation_method', 30)->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tax_type_master');
    }
};
