<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exam_increment_masters', function (Blueprint $table) {
            $table->id('exam_type_id');
            $table->string('exam_code', 30)->unique();
            $table->string('exam_name', 100);
            $table->decimal('increment_amount', 10, 2)->nullable();
            $table->string('increment_details', 255)->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exam_increment_masters');
    }
};
