<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fas_loan_document_master', function (Blueprint $table) {
            $table->id('doc_id');
            $table->string('doc_code', 20)->unique();
            $table->string('doc_name', 100);
            $table->unsignedBigInteger('loan_type_id')->nullable();
            $table->boolean('is_mandatory')->default(true);
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->foreign('loan_type_id')->references('loan_type_id')->on('fas_loan_type_master')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fas_loan_document_master');
    }
};
