<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('employee_master', function (Blueprint $table) {
            $table->id('emp_id');
            $table->string('emp_code', 20)->unique();
            $table->string('first_name', 50);
            $table->string('last_name', 50)->nullable();
            $table->unsignedInteger('dept_id')->nullable();
            $table->unsignedInteger('designation_id')->nullable();
            $table->unsignedInteger('grade_id')->nullable();
            $table->unsignedInteger('emp_type_id')->nullable();
            $table->date('doj')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();

            // Shorter composite index names
            $table->index(['dept_id', 'designation_id'], 'emp_dept_desig_idx');
            $table->index(['grade_id', 'emp_type_id'], 'emp_grade_type_idx');
            $table->index(['dept_id', 'is_active'], 'emp_dept_active_idx');

            // Individual indexes for common queries
            $table->index('emp_code', 'emp_code_idx');
            $table->index('first_name', 'emp_fname_idx');
            $table->index('doj', 'emp_doj_idx');
        });
    }

    public function down()
    {
        Schema::dropIfExists('employee_master');
    }
};
