<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('family_info_master', function (Blueprint $table) {
            $table->unsignedBigInteger('emp_id')->nullable()->after('family_id');
            $table->enum('gender', ['male', 'female', 'other'])->nullable()->after('member_name');

            // Add foreign key constraint
            $table->foreign('emp_id')
                  ->references('emp_id')
                  ->on('employee_master')
                  ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('family_info_master', function (Blueprint $table) {
            $table->dropForeign(['emp_id']);
            $table->dropColumn(['emp_id', 'gender']);
        });
    }
};
