<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('education_master', function (Blueprint $table) {
            $table->enum('is_mandatory', ['Y', 'N'])->default('N')->after('is_active');
            $table->enum('is_technical', ['Y', 'N'])->default('N')->after('is_mandatory');
            $table->enum('is_professional', ['Y', 'N'])->default('N')->after('is_technical');
            $table->enum('valid_for_recruitment', ['Y', 'N'])->default('N')->after('is_professional');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('education_master', function (Blueprint $table) {
            $table->dropColumn(['is_mandatory', 'is_technical', 'is_professional', 'valid_for_recruitment']);
        });
    }
};
