<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('fas_grant_type_master', function (Blueprint $table) {
            $table->id('grant_type_id');
            $table->string('grant_code', 25)->unique();
            $table->string('grant_name', 100);
            $table->string('gt_nature', 25)->comment('Revenue / Capital')->nullable();
            $table->enum('gt_condition', ['Y', 'N'])->default('N')->comment('Y/N');
            $table->date('gt_util_from_date')->nullable();
            $table->date('gt_util_to_date')->nullable();
            $table->string('gt_act_mode', 50)->comment('Income / Liability / Differed')->nullable();
            $table->string('gt_status', 25)->default('Active');
            $table->foreignId('gr_au_id')->nullable()->constrained('gr_authority_masters', 'gr_au_id')->nullOnDelete();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('fas_grant_type_master');
    }
};
