<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('fas_funds_type_master', function (Blueprint $table) {
            // Add the foreign key column
            $table->unsignedBigInteger('grant_category_id')->nullable()->after('funds_name');

            // Add foreign key constraint
            $table->foreign('grant_category_id')
                  ->references('id')
                  ->on('grant_category_masters')
                  ->onDelete('set null')
                  ->onUpdate('cascade');
        });
    }

    public function down()
    {
        Schema::table('fas_funds_type_master', function (Blueprint $table) {
            // Drop foreign key constraint first
            $table->dropForeign(['grant_category_id']);

            // Drop the column
            $table->dropColumn('grant_category_id');
        });
    }
};
