<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('main_departments', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('desc', 255)->nullable();
            $table->unsignedBigInteger('category_id')->nullable();
            $table->unsignedBigInteger('func_id')->nullable();
            $table->string('Menu_Links', 255)->nullable();
            $table->string('Upgrp', 255)->nullable();
            $table->string('Grcod', 255)->nullable();
            $table->string('Grsm', 255)->nullable();
            $table->string('Grsh', 255)->nullable();
            $table->tinyInteger('isvisible')->default(1)->comment('0=Inactive, 1=Active');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('main_departments');
    }
};
