<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('financial_year_master', function (Blueprint $table) {
            $table->id('financial_year_id');
            $table->string('financial_year_code', 9)->unique();
            $table->string('financial_year_name', 20)->nullable();
            $table->date('start_date');
            $table->date('end_date');
            $table->boolean('is_current_year')->default(false);
            $table->boolean('is_budget_open')->default(false);
            $table->boolean('is_transaction_open')->default(false);
            $table->boolean('is_month_end_closed')->default(false);
            $table->boolean('is_year_end_closed')->default(false);
            $table->unsignedBigInteger('previous_year_id')->nullable();
            $table->unsignedBigInteger('next_year_id')->nullable();
            $table->string('remarks', 255)->nullable();
            $table->enum('status', ['ACTIVE', 'CLOSED', 'LOCKED'])->default('ACTIVE');
            $table->timestamps();

            // Self-referential foreign keys
            $table->foreign('previous_year_id')->references('financial_year_id')->on('financial_year_master')->onDelete('set null');
            $table->foreign('next_year_id')->references('financial_year_id')->on('financial_year_master')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('financial_year_master');
    }
};
