<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('department_management', function (Blueprint $table) {
            $table->id('Dept_Mng_Id');
            $table->unsignedBigInteger('Dept_Id');
            $table->string('Wef_Date', 25);
            $table->unsignedBigInteger('Dept_User_Id');
            $table->unsignedBigInteger('Dept_Post_ID');
            $table->unsignedBigInteger('reporting_user_id')->nullable();

            $table->timestamps();

            // Foreign key constraints
            $table->foreign('Dept_Id')->references('id')->on('main_departments')->onDelete('cascade');
            $table->foreign('Dept_User_Id')->references('user_id')->on('gmc_users')->onDelete('cascade');
            $table->foreign('Dept_Post_ID')->references('designation_id')->on('employee_designation_master')->onDelete('cascade');
            $table->foreign('reporting_user_id')->references('user_id')->on('gmc_users')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('department_management');
    }
};
