<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('ledger_dep_mapping', function (Blueprint $table) {
            $table->bigIncrements('Led_d_map');
            $table->unsignedBigInteger('Dep_Id')->nullable();
            $table->json('Ledg_IDs')->nullable(); // Changed from Ledg_ID to Ledg_IDs (JSON array)
            $table->timestamps();

            // Foreign key constraint for department
            $table->foreign('Dep_Id')
                  ->references('id')
                  ->on('main_departments')
                  ->onDelete('set null');

            // Note: No foreign key for Ledg_IDs because it's JSON array

            // Index for better performance
            $table->index(['Dep_Id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('ledger_dep_mapping');
    }
};
