<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('coa_dep_mapping', function (Blueprint $table) {
            $table->bigIncrements('coa_dep_map');
            $table->unsignedBigInteger('Dep_Id')->nullable();
            $table->json('Ledg_IDs')->nullable(); // JSON array for multiple ledger IDs
            $table->timestamps();

            // Foreign key constraint for department
            $table->foreign('Dep_Id')
                  ->references('id')
                  ->on('main_departments')
                  ->onDelete('set null');

            // Index for better performance
            $table->index(['Dep_Id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('coa_dep_mapping');
    }
};
