<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        Schema::create('coa_dep_mapping', function (Blueprint $table) {
            $table->bigIncrements('coa_dep_map');
            $table->unsignedBigInteger('Dep_Id')->nullable();
            $table->json('Gr_IDs')->nullable(); // Changed from Ledg_IDs to Gr_IDs (JSON array for multiple group IDs)
            $table->timestamps();

            // Foreign key constraint for department
            $table->foreign('Dep_Id')
                  ->references('id')
                  ->on('main_departments')
                  ->onDelete('set null');

            // Index for better performance
            $table->index(['Dep_Id']);
        });

        // If you want to transfer data from existing table
        // DB::statement('INSERT INTO coa_dep_mapping (Dep_Id, Gr_IDs) SELECT Dep_Id, Ledg_IDs FROM ledger_dep_mapping');
    }

    public function down()
    {
        Schema::dropIfExists('coa_dep_mapping');
    }
};
