<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('finan_trns', function (Blueprint $table) {
            // Add Org_Id column
            $table->bigInteger('Org_Id')->unsigned()->nullable()->after('Ft_Id');

            // Add Org_Id foreign key constraint
            $table->foreign('Org_Id')
                  ->references('Org_Id')
                  ->on('organisation_settings')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('finan_trns', function (Blueprint $table) {
            // Remove Org_Id foreign key and column
            $table->dropForeign(['Org_Id']);
            $table->dropColumn('Org_Id');
        });
    }
};
