<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('budget_entries', function (Blueprint $table) {
            // Sug_Amount फ़ील्ड जोड़ें
            $table->decimal('Sug_Amount', 15, 2)->nullable()->after('Amount')
                  ->comment('Suggested amount for revision');

            // Ref_Id फ़ील्ड जोड़ें (self-referencing foreign key)
            $table->unsignedBigInteger('Ref_Id')->nullable()->after('Sug_Amount')
                  ->comment('Reference to previous budget entry for tracking revisions');

            // Foreign key constraint for Ref_Id (self-referencing)
            $table->foreign('Ref_Id')->references('Budg_Id')->on('budget_entries')->onDelete('set null');

            // Index for performance
            $table->index('Ref_Id');
            $table->index('Sug_Amount');
        });
    }

    public function down()
    {
        Schema::table('budget_entries', function (Blueprint $table) {
            // Drop foreign key first
            $table->dropForeign(['Ref_Id']);

            // Drop columns
            $table->dropColumn(['Sug_Amount', 'Ref_Id']);
        });
    }
};
