<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('budget_entries', function (Blueprint $table) {
            // Add Beg_Doc column as JSON to store multiple document paths
            // JSON is better for storing array of file paths
            $table->json('Beg_Doc')->nullable()->after('Amount')->comment('Multiple document attachments for budget entry');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('budget_entries', function (Blueprint $table) {
            $table->dropColumn('Beg_Doc');
        });
    }
};
