<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Direct SQL queries use करें safe रहने के लिए
        try {
            // budget_entries table update
            if (Schema::hasTable('budget_entries') && Schema::hasColumn('budget_entries', 'Status')) {
                DB::statement("ALTER TABLE budget_entries MODIFY COLUMN Status VARCHAR(25) NULL COMMENT 'D=Draft, R=Revised, P=Approve, F=Freeze, A=Active, I=Inactive, RR=Re-Revised, RJ=Reject, J=Justification'");
            }

            // budget_log_books table update (यह exists है)
            if (Schema::hasTable('budget_log_books')) {
                if (Schema::hasColumn('budget_log_books', 'Status')) {
                    DB::statement("ALTER TABLE budget_log_books MODIFY COLUMN Status VARCHAR(25) NULL");
                }

                if (Schema::hasColumn('budget_log_books', 'previous_status')) {
                    DB::statement("ALTER TABLE budget_log_books MODIFY COLUMN previous_status VARCHAR(25) NULL");
                }
            }
        } catch (\Exception $e) {
            // Error handle करें
            throw $e;
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        try {
            // budget_entries table revert
            if (Schema::hasTable('budget_entries') && Schema::hasColumn('budget_entries', 'Status')) {
                DB::statement("ALTER TABLE budget_entries MODIFY COLUMN Status VARCHAR(25) NULL COMMENT 'Draft, Revised, Approve, Freeze'");
            }

            // budget_log_books table revert
            if (Schema::hasTable('budget_log_books')) {
                if (Schema::hasColumn('budget_log_books', 'Status')) {
                    DB::statement("ALTER TABLE budget_log_books MODIFY COLUMN Status VARCHAR(25) NULL");
                }

                if (Schema::hasColumn('budget_log_books', 'previous_status')) {
                    DB::statement("ALTER TABLE budget_log_books MODIFY COLUMN previous_status VARCHAR(25) NULL");
                }
            }
        } catch (\Exception $e) {
        }
    }
};
