<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vendor_invoice_parameters', function (Blueprint $table) {
            $table->id('proposal_id');
            $table->unsignedBigInteger('tend_work_id');
            $table->date('effective_date');
            $table->json('tax_parameters');
            $table->timestamps();
            $table->softDeletes();

            // Indexes
            $table->index('tend_work_id');
            $table->index('effective_date');
        });

        // Foreign key for tender work
        Schema::table('vendor_invoice_parameters', function (Blueprint $table) {
            $table->foreign('tend_work_id')
                ->references('tend_work_id')
                ->on('new_tender_works')
                ->onDelete('restrict')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vendor_invoice_parameters', function (Blueprint $table) {
            $table->dropForeign(['tend_work_id']);
        });

        Schema::dropIfExists('vendor_invoice_parameters');
    }
};
