<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // payment_status enum में 'quary' status जोड़ें
        Schema::table('payment_vouchers', function (Blueprint $table) {
            $table->enum('payment_status', ['draft', 'pending', 'approved', 'paid', 'cancelled', 'quary'])
                  ->default('draft')
                  ->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // 'quary' status हटाएं
        Schema::table('payment_vouchers', function (Blueprint $table) {
            $table->enum('payment_status', ['draft', 'pending', 'approved', 'paid', 'cancelled'])
                  ->default('draft')
                  ->change();
        });
    }
};
