<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ModifyRefIdInFinanTrnsTable extends Migration
{
    public function up()
    {
        Schema::table('finan_trns', function (Blueprint $table) {
            // If ref_id doesn't exist
            if (!Schema::hasColumn('finan_trns', 'ref_id')) {
                $table->unsignedBigInteger('ref_id')->nullable()->after('dr_amt');
            } else {
                // If it exists but as string/decimal, modify it
                $table->unsignedBigInteger('ref_id')->nullable()->change();
            }

            // Add foreign key constraint
            $table->foreign('ref_id')
                  ->references('Lg_Id')
                  ->on('ledger_master')
                  ->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('finan_trns', function (Blueprint $table) {
            $table->dropForeign(['ref_id']);
            // Optionally revert to string if needed
            $table->string('ref_id')->nullable()->change();
        });
    }
}
