<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('payroll_master', function (Blueprint $table) {
            $table->id('payroll_id');
            $table->unsignedBigInteger('Lg_Id')->nullable();
            $table->string('payroll_code', 20)->unique();
            $table->string('payroll_name', 100);
            $table->decimal('payroll_percentage', 5, 2)->default(0.00);
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('Lg_Id')->references('Lg_Id')->on('ledger_master')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('payroll_master');
    }
};
