<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pay_rate_master', function (Blueprint $table) {
            $table->id('pay_rate_id');
            $table->unsignedBigInteger('emp_type_id'); // NEW: Employee Type FK
            $table->date('effective_date');
            $table->json('pay_parameters');
            $table->timestamps();
            $table->softDeletes();

            // Composite unique constraint to prevent duplicates
            $table->unique(['emp_type_id', 'effective_date'], 'pay_rate_emp_type_date_unique');

            // Indexes
            $table->index('emp_type_id');
            $table->index('effective_date');
        });

        // Foreign key for employee type
        Schema::table('pay_rate_master', function (Blueprint $table) {
            $table->foreign('emp_type_id')
                ->references('emp_type_id')
                ->on('employee_type_master')
                ->onDelete('restrict')
                ->onUpdate('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('pay_rate_master', function (Blueprint $table) {
            $table->dropForeign(['emp_type_id']);
            $table->dropUnique('pay_rate_emp_type_date_unique');
        });

        Schema::dropIfExists('pay_rate_master');
    }
};
