<?php
// database/migrations/xxxx_xx_xx_create_pay_scale_masters_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayScaleMastersTable extends Migration
{
    public function up()
    {
        Schema::create('pay_scale_masters', function (Blueprint $table) {
            $table->id('pay_scale_id');
            $table->unsignedBigInteger('commission_id');
            $table->string('scale_code', 20);
            $table->decimal('start_basic', 10, 2);
            $table->decimal('increment_amount', 10, 2);
            $table->integer('increment_steps');
            $table->decimal('max_basic', 10, 2);
            $table->timestamps();

            $table->foreign('commission_id')
                  ->references('commission_id')
                  ->on('pay_commission_masters')
                  ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('pay_scale_masters');
    }
}
