<?php
// database/migrations/xxxx_xx_xx_create_pay_matrix_cell_masters_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayMatrixCellMastersTable extends Migration
{
    public function up()
    {
        Schema::create('pay_matrix_cell_masters', function (Blueprint $table) {
            $table->id('cell_id');
            $table->unsignedBigInteger('level_id');
            $table->integer('cell_index');
            $table->decimal('basic_pay', 10, 2);
            $table->timestamps();

            $table->foreign('level_id')
                  ->references('level_id')
                  ->on('pay_matrix_level_masters')
                  ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('pay_matrix_cell_masters');
    }
}
