<?php
// database/migrations/xxxx_xx_xx_create_designation_pay_mappings_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDesignationPayMappingsTable extends Migration
{
    public function up()
    {
        Schema::create('designation_pay_mappings', function (Blueprint $table) {
            $table->id('mapping_id');
            $table->unsignedBigInteger('designation_id');
            $table->unsignedBigInteger('commission_id');
            $table->unsignedBigInteger('structure_type_id');
            $table->unsignedBigInteger('pay_scale_id')->nullable();
            $table->unsignedBigInteger('pay_band_id')->nullable();
            $table->unsignedBigInteger('grade_pay_id')->nullable();
            $table->unsignedBigInteger('level_id')->nullable();
            $table->timestamps();

            $table->foreign('designation_id')
                  ->references('designation_id')
                  ->on('designation_masters')
                  ->onDelete('cascade');

            $table->foreign('commission_id')
                  ->references('commission_id')
                  ->on('pay_commission_masters')
                  ->onDelete('cascade');

            $table->foreign('structure_type_id')
                  ->references('structure_type_id')
                  ->on('pay_structure_type_masters')
                  ->onDelete('cascade');

            $table->foreign('pay_scale_id')
                  ->references('pay_scale_id')
                  ->on('pay_scale_masters')
                  ->onDelete('set null');

            $table->foreign('pay_band_id')
                  ->references('pay_band_id')
                  ->on('pay_band_masters')
                  ->onDelete('set null');

            $table->foreign('grade_pay_id')
                  ->references('grade_pay_id')
                  ->on('grade_pay_masters')
                  ->onDelete('set null');

            $table->foreign('level_id')
                  ->references('level_id')
                  ->on('pay_matrix_level_masters')
                  ->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('designation_pay_mappings');
    }
}
