<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('pay_commission_masters', function (Blueprint $table) {
            $table->unsignedBigInteger('structure_type_id')
                ->nullable()
                ->after('commission_name');

            $table->foreign('structure_type_id')
                ->references('structure_type_id')
                ->on('pay_structure_type_masters')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('pay_commission_masters', function (Blueprint $table) {
            $table->dropForeign(['structure_type_id']);
            $table->dropColumn('structure_type_id');
        });
    }
};
