<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('work_allocation', function (Blueprint $table) {
            $table->id('wk_allow');
            $table->unsignedBigInteger('SL_Id')->nullable();
            $table->unsignedBigInteger('Tend_Ent_Id')->nullable();
            $table->decimal('work_amount', 15, 2)->nullable();
            $table->date('work_date')->nullable();
            $table->timestamps();

            $table->foreign('SL_Id')->references('SL_Id')->on('subledg_master')->nullOnDelete();
            $table->foreign('Tend_Ent_Id')->references('Tend_Ent_Id')->on('tender_entry_master')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('work_allocation');
    }
};
