<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('da_masters', function (Blueprint $table) {
            $table->bigIncrements('da_id');

            $table->string('da_sr')->nullable();
            $table->date('fr_date')->nullable();
            $table->date('to_date')->nullable();
            $table->date('eff_date')->nullable();

            $table->unsignedBigInteger('commission_id')->nullable();

            $table->string('da_rate')->nullable();
            $table->string('da_paid')->nullable();
            $table->string('da_diff')->nullable();
            $table->string('npa_rate')->nullable();
            $table->string('npa_limit')->nullable();
            $table->string('dapf')->nullable();
            $table->string('bon_limit')->nullable();
            $table->string('ir_rate')->nullable();
            $table->string('da_diff_mon')->nullable();
            $table->string('da_diff_rate')->nullable();

            $table->timestamps();

            // ✅ FK reference
            $table->foreign('commission_id')
                ->references('commission_id')
                ->on('pay_commission_masters')
                ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('da_masters');
    }
};
