<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('des_post_books', function (Blueprint $table) {
            $table->bigIncrements('dp_id');

            $table->date('dp_date')->nullable();
            $table->unsignedBigInteger('designation_id')->nullable();
            $table->string('per_post')->nullable();
            $table->string('temp_post')->nullable();

            $table->timestamps();

            // FK reference
            $table->foreign('designation_id')
                ->references('designation_id')
                ->on('designation_masters')
                ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('des_post_books');
    }
};
