<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('tax_slabs', function (Blueprint $table) {
            $table->bigIncrements('its_id');

            $table->date('ef_date')->nullable();
            $table->string('tax_type')->nullable();
            $table->string('sl_from')->nullable();
            $table->string('sl_to')->nullable();
            $table->string('tax_rate')->nullable();
            $table->string('tax_mode')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tax_slabs');
    }
};
