<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('department_menu_mappings', function (Blueprint $table) {

            $table->id('Dept_menu_map_Id');

            $table->unsignedBigInteger('Dept_Id')->nullable();
            $table->unsignedBigInteger('Menu_ID')->nullable();

            $table->boolean('Status')->default(1); // 1=Active,0=Inactive
            $table->timestamps();

            // 🔗 Foreign Keys
            $table->foreign('Dept_Id')
                ->references('id')
                ->on('main_departments')
                ->onDelete('cascade');

            $table->foreign('Menu_ID')
                ->references('id')
                ->on('function_types')
                ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('department_menu_mappings');
    }
};
