<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('department_menu_mappings', function (Blueprint $table) {

            // remove old foreign key & column
            $table->dropForeign(['Dept_Id']);
            $table->dropColumn('Dept_Id');

            // add new JSON column
            $table->json('Dept_IDs')->after('Dept_menu_map_Id');
        });
    }

    public function down(): void
    {
        Schema::table('department_menu_mappings', function (Blueprint $table) {

            // rollback
            $table->unsignedBigInteger('Dept_Id')->nullable();
            $table->dropColumn('Dept_IDs');

            $table->foreign('Dept_Id')
                ->references('id')
                ->on('main_departments')
                ->onDelete('cascade');
        });
    }
};
