<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CoMasterController;
use App\Http\Controllers\BranchMController;
use App\Http\Controllers\LedgGrpController;
use App\Http\Controllers\PrtyMastController;
use App\Http\Controllers\FinanTrnController;
use App\Http\Controllers\SubFinanTrnController;
use App\Http\Controllers\RoleMasterController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\SubCategoryController;
use App\Http\Controllers\SubSubCategoryController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\AwardMasterController;
use App\Http\Controllers\GmcUserController;
use App\Http\Controllers\UserRoleMappingController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\DeviceInfoController;
use App\Http\Controllers\DeviceApprovalController;
use App\Http\Controllers\ModuleController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\PermissionTypeController;
use App\Http\Controllers\FasDebtTypeMasterController;
use App\Http\Controllers\FasFundsTypeMasterController;
use App\Http\Controllers\FasGrantTypeMasterController;
use App\Http\Controllers\FasLoanTypeMasterController;
use App\Http\Controllers\ZoneMasterController;
use App\Http\Controllers\WardMasterController;
use App\Http\Controllers\CccMasterController;
use App\Http\Controllers\EducationMasterController;
use App\Http\Controllers\EmployeeCategoryMasterController;
use App\Http\Controllers\EmployeeGradeMasterController;
use App\Http\Controllers\EmployeeLanguageMasterController;
use App\Http\Controllers\EmployeeQuotaMasterController;
use App\Http\Controllers\EmployeeStatusMasterController;
use App\Http\Controllers\EmployeeTypeMasterController;
use App\Http\Controllers\ExamIncrementMasterController;
use App\Http\Controllers\FasLoanDocumentMasterController;
use App\Http\Controllers\SchemeTypeMasterController;
use App\Http\Controllers\FunctionTypeController;
use App\Http\Controllers\InquiryMasterController;
use App\Http\Controllers\LeaveTypeMasterController;
use App\Http\Controllers\OrganisationSettingController;
use App\Http\Controllers\OrganisationFinYearController;
use App\Http\Controllers\WardStatisticController;
use App\Http\Controllers\LedgerMasterController;
use App\Http\Controllers\SubLedgerMasterController;
use App\Http\Controllers\PermissionRoleController;
use App\Http\Controllers\SchemeMasterController;
use App\Http\Controllers\SignificantWorkMasterController;
use App\Http\Controllers\SpecialDutyMasterController;
use App\Http\Controllers\TaxTypeMasterController;
use App\Http\Controllers\GrAuthorityMasterController;
use App\Http\Controllers\GrantDivisionMappingController;
use App\Http\Controllers\AreaMasterController;
use App\Http\Controllers\RelationshipMasterController;
use App\Http\Controllers\FamilyInfoMasterController;
use App\Http\Controllers\EmployeeMasterController;
use App\Http\Controllers\QualificationLevelController;
use App\Http\Controllers\StreamController;
use App\Http\Controllers\RecognizedByController;
use App\Http\Controllers\GrantCategoryMasterController;
use App\Http\Controllers\MainDepartmentController;
use App\Http\Controllers\FinancialYearMasterController;
use App\Http\Controllers\DepartmentManagementController;
use App\Http\Controllers\BudgetEntryController;
use App\Http\Controllers\BudgetLogBookController;
use App\Http\Controllers\LedgerDepMappingController;
use App\Http\Controllers\CoaDepMappingController;
use App\Http\Controllers\NewTenderWorkController;
use App\Http\Controllers\EMDBGTypeMasterController;
use App\Http\Controllers\InstrumentMasterController;
use App\Http\Controllers\VendorInvoiceParameterController;
use App\Http\Controllers\DocumentLibraryController;
use App\Http\Controllers\TenderEntryMasterController;
use App\Http\Controllers\FaTaxTypeMasterController;
use App\Http\Controllers\TendorAllocationController;
use App\Http\Controllers\PaymentVoucherController;
use App\Http\Controllers\GrantEntryController;
use App\Http\Controllers\TenderPeneltyController;
use App\Http\Controllers\PayrollMasterController;
use App\Http\Controllers\PayRateMasterController;
use App\Http\Controllers\DAMasterController;
use App\Http\Controllers\DesPostBookController;
use App\Http\Controllers\DepartmentMenuMappingController;

use App\Http\Controllers\UserDepartmentMappingController;
use App\Http\Controllers\TaxSlabController;
use App\Http\Controllers\WorkAllocationController;
use App\Http\Controllers\DeviceApprovalLogController;
use App\Http\Controllers\StatusController;
use App\Http\Controllers\{
    PayCommissionMasterController,
    PayStructureTypeMasterController,
    PayScaleMasterController,
    PayBandMasterController,
    GradePayMasterController,
    PayMatrixLevelMasterController,
    PayMatrixCellMasterController,
    DesignationMasterController,
    DesignationMenuController,
    DesignationPayMappingController,
    FunctionTypesTwoController,
    RecruitmentTypeController
};
use App\Http\Controllers\RolePermissionController;

Route::apiResource('co-masters', CoMasterController::class);
Route::apiResource('branch-ms', BranchMController::class);



// CRUD routes
Route::apiResource('ledg-grps', LedgGrpController::class);


// Additional routes
Route::post('ledg-grps/import-excel', [LedgGrpController::class, 'importExcel']);
Route::get('ledg-grps/tree/{coId}', [LedgGrpController::class, 'getTree']);
Route::get('ledg-grps/generate-preview', [LedgGrpController::class, 'generateCodePreview']);
Route::post('ledg-grps/search', [LedgGrpController::class, 'search']);
Route::put('ledg-grps/soft-delete/{id}', [LedgGrpController::class, 'softDelete']);
Route::put('ledg-grps/restore/{id}', [LedgGrpController::class, 'restore']);
Route::post('ledg-grps/bulk-update', [LedgGrpController::class, 'bulkUpdate']);
Route::get('ledg-grps/export-excel/{coId}', [LedgGrpController::class, 'exportExcel']);
Route::get('ledg-grps/{id}/parent', [LedgGrpController::class, 'getParentDetails']);
Route::get('ledg-grps/{id}/children', [LedgGrpController::class, 'getChildren']);


Route::apiResource('prty-masts', PrtyMastController::class);
Route::apiResource('finan-trns', FinanTrnController::class);
Route::apiResource('sub-finan-trns', SubFinanTrnController::class);
Route::get('/financial-summary', [FinanTrnController::class, 'getFinancialSummary']);
Route::post('finan-trns/single', [FinanTrnController::class, 'storeSingle']);
Route::get('/transaction-details', [FinanTrnController::class, 'getTransactionDetails']);







Route::prefix('employee-master')->group(function () {
    // Specific routes FIRST
    Route::get('/all', [EmployeeMasterController::class, 'getAllEmployees']);
    Route::get('/list', [EmployeeMasterController::class, 'employeeList']);

    // CRUD Operations
    Route::get('/', [EmployeeMasterController::class, 'index']);
    Route::post('/', [EmployeeMasterController::class, 'store']);

    // Dynamic routes LAST
    Route::get('/{id}', [EmployeeMasterController::class, 'show']);
    Route::put('/{id}', [EmployeeMasterController::class, 'update']);
    Route::delete('/{id}', [EmployeeMasterController::class, 'destroy']);
});



// Role Master Routes
Route::prefix('roles')->group(function () {
    Route::get('/', [RoleMasterController::class, 'index']);
    Route::get('/all-list', [RoleMasterController::class, 'getAllRolesList']);
    Route::post('/', [RoleMasterController::class, 'store']);
    Route::post('/bulk', [RoleMasterController::class, 'bulkStore']);
    Route::get('/{id}', [RoleMasterController::class, 'show']);
    Route::put('/{id}', [RoleMasterController::class, 'update']);
    Route::delete('/{id}', [RoleMasterController::class, 'destroy']);
    Route::post('/{id}/activate', [RoleMasterController::class, 'activate']);
    Route::post('/{id}/deactivate', [RoleMasterController::class, 'deactivate']);
    Route::post('/{id}/enable-two-factor', [RoleMasterController::class, 'enableTwoFactorAuth']);
    Route::post('/{id}/disable-two-factor', [RoleMasterController::class, 'disableTwoFactorAuth']);
    Route::get('/with-user-count/all', [RoleMasterController::class, 'getRolesWithUserCount']);
});
Route::apiResource('categories', CategoryController::class);
Route::get('categories/paginate', [CategoryController::class, 'paginate']);

// SubCategory Routes (only basic CRUD + paginate)
Route::apiResource('sub-categories', SubCategoryController::class);
Route::get('sub-categories/paginate', [SubCategoryController::class, 'paginate']);

// SubSubCategory Routes (only basic CRUD + paginate)
Route::apiResource('sub-sub-categories', SubSubCategoryController::class);
Route::get('sub-sub-categories/paginate', [SubSubCategoryController::class, 'paginate']);

Route::post('login', [AuthController::class, 'login']);
Route::post('verify-mfa', [AuthController::class, 'verifyMfa']);


Route::post('logout', [AuthController::class, 'logout']);
Route::get('check-session', [AuthController::class, 'checkSession']);
Route::post('change-password', [AuthController::class, 'changePassword']);

// User Profile
Route::get('profile', [GmcUserController::class, 'profile']);
Route::put('profile', [GmcUserController::class, 'updateProfile']);

// User Management
Route::apiResource('users', GmcUserController::class);
Route::get('users/all/list', [GmcUserController::class, 'getAllUsers']);
Route::post('users/{id}/restore', [GmcUserController::class, 'restore']);
Route::post('users/{id}/toggle-mfa', [GmcUserController::class, 'toggleMfa']);
Route::post('users/{id}/toggle-lock', [GmcUserController::class, 'toggleLock']);
Route::post('users/{id}/reset-password', [GmcUserController::class, 'resetPassword']);
Route::get('users/{id}/sessions', [GmcUserController::class, 'getUserSessions']);
Route::get('users/{id}/audit-logs', [GmcUserController::class, 'getUserAuditLogs']);


Route::apiResource('role-mappings', UserRoleMappingController::class);

// Additional endpoints
Route::get('users/{userId}/roles', [UserRoleMappingController::class, 'getUserRoles']);
Route::get('roles/{roleId}/users', [UserRoleMappingController::class, 'getRoleUsers']);
Route::post('users/{userId}/assign-roles', [UserRoleMappingController::class, 'assignMultipleRoles']);
Route::post('users/{userId}/set-default-role', [UserRoleMappingController::class, 'setDefaultRole']);
Route::post('role-mappings/bulk/update', [UserRoleMappingController::class, 'bulkUpdate']);
Route::get('roles/{roleId}/users-without', [UserRoleMappingController::class, 'getUsersWithoutRole']);


Route::apiResource('areas', AreaMasterController::class);

// Custom search route
Route::get('areas/search/query', [AreaMasterController::class, 'search']);

// Department Routes
Route::prefix('departments')->group(function () {
    Route::get('/', [DepartmentController::class, 'index']);                    // Paginated list
    Route::get('/all/list', [DepartmentController::class, 'getAllDepartments']); // All data without pagination
    Route::post('/', [DepartmentController::class, 'store']);
    Route::get('/active', [DepartmentController::class, 'activeDepartments']);
    Route::get('/{id}', [DepartmentController::class, 'show']);
    Route::put('/{id}', [DepartmentController::class, 'update']);
    Route::delete('/{id}', [DepartmentController::class, 'destroy']);
    Route::get('/building/{building}', [DepartmentController::class, 'getByBuilding']);
    Route::get('/{id}/statistics', [DepartmentController::class, 'getStatistics']);
    Route::post('/check-ip', [DepartmentController::class, 'checkIP']);
    Route::get('/{id}/users', [DepartmentController::class, 'getUsers']);
});


// Grant Authority Master Routes
Route::prefix('grant-authorities')->group(function () {
    Route::get('/', [GrAuthorityMasterController::class, 'index']);
    Route::get('/all', [GrAuthorityMasterController::class, 'getAll']); // Get all including inactive
    Route::post('/', [GrAuthorityMasterController::class, 'store']);
    Route::get('/{id}', [GrAuthorityMasterController::class, 'show']);
    Route::put('/{id}', [GrAuthorityMasterController::class, 'update']);
    Route::delete('/{id}', [GrAuthorityMasterController::class, 'destroy']);
    Route::put('/{id}/restore', [GrAuthorityMasterController::class, 'restore']);
});


Route::prefix('device')->group(function () {
    Route::post('capture', [DeviceInfoController::class, 'getDeviceInfo']);
    Route::post('register', [DeviceInfoController::class, 'registerDevice']);
});

// Device Approval Management Routes
Route::prefix('device-approvals')->group(function () {
    // Queue Management
    Route::get('queue', [DeviceApprovalController::class, 'getPendingQueue']);
    Route::post('queue/{queueId}/approve', [DeviceApprovalController::class, 'approveDevice']);
    Route::post('queue/{queueId}/reject', [DeviceApprovalController::class, 'rejectDevice']);

    // User Devices
    Route::get('user/{userId}/devices', [DeviceApprovalController::class, 'getUserDevices']);

    // Device Management
    Route::post('devices/{approvalId}/renew', [DeviceApprovalController::class, 'renewDevice']);
    Route::post('devices/{approvalId}/revoke', [DeviceApprovalController::class, 'revokeDevice']);
    Route::get('devices/{approvalId}/hardware-status', [DeviceApprovalController::class, 'checkHardwareStatus']);

    // Statistics
    Route::get('statistics', [DeviceApprovalController::class, 'getStatistics']);
});


// Module Routes
Route::prefix('modules')->group(function () {
    Route::get('/', [ModuleController::class, 'index']);
    Route::post('/', [ModuleController::class, 'store']);
    Route::get('/{id}', [ModuleController::class, 'show']);
    Route::put('/{id}', [ModuleController::class, 'update']);
    Route::delete('/{id}', [ModuleController::class, 'destroy']);
});

// Permission Routes
Route::prefix('permissions')->group(function () {
    Route::get('/', [PermissionController::class, 'index']);
    Route::post('/', [PermissionController::class, 'store']);
    Route::get('/{id}', [PermissionController::class, 'show']);
    Route::put('/{id}', [PermissionController::class, 'update']);
    Route::delete('/{id}', [PermissionController::class, 'destroy']);
    Route::get('/module/{moduleId}', [PermissionController::class, 'getByModule']);
});

// Permission Type Routes
Route::prefix('permission-types')->group(function () {
    Route::get('/', [PermissionTypeController::class, 'index']);
    Route::post('/', [PermissionTypeController::class, 'store']);
    Route::get('/{id}', [PermissionTypeController::class, 'show']);
    Route::put('/{id}', [PermissionTypeController::class, 'update']);
    Route::delete('/{id}', [PermissionTypeController::class, 'destroy']);
});

// Permission-Role assignment routes
Route::prefix('permission-roles')->group(function () {
    Route::get('/', [PermissionRoleController::class, 'index']);
    Route::post('/', [PermissionRoleController::class, 'store']);
    Route::post('/bulk-assign', [PermissionRoleController::class, 'bulkAssign']);
    Route::get('/role/{roleId}/permissions', [PermissionRoleController::class, 'permissionsByRole']);
    Route::get('/permission/{permissionId}/roles', [PermissionRoleController::class, 'rolesByPermission']);

    // Composite key routes
    Route::prefix('{permissionId}/{roleId}')->group(function () {
        Route::get('/', [PermissionRoleController::class, 'show']);
        Route::put('/', [PermissionRoleController::class, 'update']);
        Route::delete('/', [PermissionRoleController::class, 'destroy']);
    });
});


Route::apiResource('debt-types', FasDebtTypeMasterController::class);
Route::post('debt-types/{id}/restore', [FasDebtTypeMasterController::class, 'restore']);
Route::get('debt-types/options', [FasDebtTypeMasterController::class, 'getOptions']);
// Funds Types API
Route::apiResource('funds-types', FasFundsTypeMasterController::class);
Route::post('funds-types/{id}/restore', [FasFundsTypeMasterController::class, 'restore']);

// Grant Types API
Route::apiResource('grant-types', FasGrantTypeMasterController::class);
Route::post('grant-types/{id}/restore', [FasGrantTypeMasterController::class, 'restore']);

// Loan Types API
Route::apiResource('loan-types', FasLoanTypeMasterController::class);
Route::post('loan-types/{id}/restore', [FasLoanTypeMasterController::class, 'restore']);

// Zone Master CRUD API
Route::apiResource('zone-masters', ZoneMasterController::class);

// Additional routes
Route::prefix('zone-masters')->group(function () {
    Route::get('organization/{orgId}', [ZoneMasterController::class, 'getByOrganization']);
    Route::get('global', [ZoneMasterController::class, 'getGlobalZones']);
    Route::post('bulk-create', [ZoneMasterController::class, 'bulkStore']);
});

// Ward Master Routes
Route::prefix('wards')->group(function () {
    Route::get('/', [WardMasterController::class, 'index']);
    Route::post('/', [WardMasterController::class, 'store']);
    Route::get('/{id}', [WardMasterController::class, 'show']);
    Route::put('/{id}', [WardMasterController::class, 'update']);
    Route::delete('/{id}', [WardMasterController::class, 'destroy']);
    Route::post('/{id}/restore', [WardMasterController::class, 'restore']);
    Route::get('/zone/{zoneId}', [WardMasterController::class, 'getByZone']);
});


// Ward Statistics Routes
Route::prefix('ward-statistics')->group(function () {
    Route::get('/', [WardStatisticController::class, 'index']);
    Route::post('/', [WardStatisticController::class, 'store']);
    Route::post('/bulk', [WardStatisticController::class, 'bulkStore']);
    Route::get('/{id}', [WardStatisticController::class, 'show']);
    Route::put('/{id}', [WardStatisticController::class, 'update']);
    Route::delete('/{id}', [WardStatisticController::class, 'destroy']);
    Route::post('/{id}/restore', [WardStatisticController::class, 'restore']);
    Route::get('/ward/{wardId}', [WardStatisticController::class, 'getByWard']);
    Route::get('/latest/all', [WardStatisticController::class, 'getLatestStatistics']);
});
// CCC Master Routes
Route::prefix('cccs')->group(function () {
    Route::get('/', [CccMasterController::class, 'index']);
    Route::post('/', [CccMasterController::class, 'store']);
    Route::get('/{id}', [CccMasterController::class, 'show']);
    Route::put('/{id}', [CccMasterController::class, 'update']);
    Route::delete('/{id}', [CccMasterController::class, 'destroy']);
    Route::post('/{id}/restore', [CccMasterController::class, 'restore']);
    Route::get('/ward/{wardId}', [CccMasterController::class, 'getByWard']);
    Route::get('/zone/{zoneId}', [CccMasterController::class, 'getByZone']);
});
// Scheme Type Master API
Route::apiResource('scheme-types', SchemeTypeMasterController::class);
Route::post('scheme-types/{id}/restore', [SchemeTypeMasterController::class, 'restore']);



Route::prefix('function-types')->group(function () {
    // GET all function types (with optional search)
    Route::get('/', [FunctionTypeController::class, 'index']);

    // GET single function type
    Route::get('/{id}', [FunctionTypeController::class, 'show']);

    // CREATE function type
    Route::post('/', [FunctionTypeController::class, 'store']);

    // UPDATE function type
    Route::put('/{id}', [FunctionTypeController::class, 'update']);
    Route::patch('/{id}', [FunctionTypeController::class, 'update']);

    // DELETE function type
    Route::delete('/{id}', [FunctionTypeController::class, 'destroy']);
});
Route::post('function-types/{id}/toggle-visibility', [FunctionTypeController::class, 'toggleVisibility']);

Route::apiResource('organisation-settings', OrganisationSettingController::class);

// Additional routes for soft delete functionality
Route::prefix('organisation-settings')->group(function () {
    Route::get('trashed', [OrganisationSettingController::class, 'trashed']);
    Route::patch('{id}/restore', [OrganisationSettingController::class, 'restore']);
    Route::delete('{id}/force-delete', [OrganisationSettingController::class, 'forceDelete']);
});

// Basic CRUD routes
Route::apiResource('organisation-fin-years', OrganisationFinYearController::class);

// Additional routes
Route::prefix('organisation-fin-years')->group(function () {
    Route::get('trashed', [OrganisationFinYearController::class, 'trashed']);
    Route::patch('{id}/restore', [OrganisationFinYearController::class, 'restore']);
    Route::delete('{id}/force-delete', [OrganisationFinYearController::class, 'forceDelete']);
    Route::get('organization/{orgId}', [OrganisationFinYearController::class, 'getByOrganization']);
    Route::get('current/{orgId}', [OrganisationFinYearController::class, 'getCurrentForOrganization']);
});
// Ledger Master Routes
Route::prefix('ledgers')->group(function () {
    Route::get('/', [LedgerMasterController::class, 'index']);
    Route::post('/', [LedgerMasterController::class, 'store']);
    Route::post('/bulk', [LedgerMasterController::class, 'bulkStore']);
    Route::get('/{id}', [LedgerMasterController::class, 'show']);
    Route::put('/{id}', [LedgerMasterController::class, 'update']);
    Route::delete('/{id}', [LedgerMasterController::class, 'destroy']);
    Route::post('/{id}/activate', [LedgerMasterController::class, 'activate']);
    Route::post('/{id}/deactivate', [LedgerMasterController::class, 'deactivate']);
    Route::get('/with-count/all', [LedgerMasterController::class, 'getLedgersWithCount']);
});

// SubLedgerMaster Routes
Route::prefix('sub-ledgers')->group(function () {
    Route::get('/', [SubLedgerMasterController::class, 'index']);
    Route::get('/all', [SubLedgerMasterController::class, 'getAll']);
    Route::post('/', [SubLedgerMasterController::class, 'store']);
    Route::get('/{id}', [SubLedgerMasterController::class, 'show']);
    Route::put('/{id}', [SubLedgerMasterController::class, 'update']);
    Route::delete('/{id}', [SubLedgerMasterController::class, 'destroy']);

    Route::post('/{id}/deactivate', [SubLedgerMasterController::class, 'deactivate']);
    Route::post('/{id}/activate', [SubLedgerMasterController::class, 'activate']);
    Route::get('/ledger/{ledgerId}', [SubLedgerMasterController::class, 'getByLedger']);
    Route::post('/bulk', [SubLedgerMasterController::class, 'bulkStore']);
    Route::get('/statistics', [SubLedgerMasterController::class, 'getStatistics']);
    Route::get('/compliance-report', [SubLedgerMasterController::class, 'getComplianceReport']);

    // New routes for statutory and banking
    Route::post('/{id}/verify-pan', [SubLedgerMasterController::class, 'verifyPAN']);
    Route::post('/{id}/verify-gstin', [SubLedgerMasterController::class, 'verifyGSTIN']);
    Route::post('/{id}/verify-bank-details', [SubLedgerMasterController::class, 'verifyBankDetails']);
    Route::post('/{id}/unverify-pan', [SubLedgerMasterController::class, 'unverifyPAN']);
    Route::post('/{id}/unverify-gstin', [SubLedgerMasterController::class, 'unverifyGSTIN']);
    Route::post('/{id}/unverify-bank-details', [SubLedgerMasterController::class, 'unverifyBankDetails']);

    // File routes
    Route::get('/{id}/download-cancelled-cheque', [SubLedgerMasterController::class, 'downloadCancelledCheque']);
    Route::delete('/{id}/delete-cancelled-cheque', [SubLedgerMasterController::class, 'deleteCancelledCheque']);
});



Route::get('leave-types', [LeaveTypeMasterController::class, 'index']);
Route::post('leave-types', [LeaveTypeMasterController::class, 'store']);
Route::get('leave-types/{id}', [LeaveTypeMasterController::class, 'show']);
Route::put('leave-types/{id}', [LeaveTypeMasterController::class, 'update']);
Route::delete('leave-types/{id}', [LeaveTypeMasterController::class, 'destroy']);


Route::get('significant-works', [SignificantWorkMasterController::class, 'index']);
Route::post('significant-works', [SignificantWorkMasterController::class, 'store']);
Route::get('significant-works/{id}', [SignificantWorkMasterController::class, 'show']);
Route::put('significant-works/{id}', [SignificantWorkMasterController::class, 'update']);
Route::delete('significant-works/{id}', [SignificantWorkMasterController::class, 'destroy']);


Route::get('awards', [AwardMasterController::class, 'index']);
Route::post('awards', [AwardMasterController::class, 'store']);
Route::get('awards/{id}', [AwardMasterController::class, 'show']);
Route::put('awards/{id}', [AwardMasterController::class, 'update']);
Route::delete('awards/{id}', [AwardMasterController::class, 'destroy']);



Route::get('inquiries', [InquiryMasterController::class, 'index']);
Route::post('inquiries', [InquiryMasterController::class, 'store']);
Route::get('inquiries/{id}', [InquiryMasterController::class, 'show']);
Route::put('inquiries/{id}', [InquiryMasterController::class, 'update']);
Route::delete('inquiries/{id}', [InquiryMasterController::class, 'destroy']);




Route::get('schemes', [SchemeMasterController::class, 'index']);
Route::post('schemes', [SchemeMasterController::class, 'store']);
Route::get('schemes/{id}', [SchemeMasterController::class, 'show']);
Route::put('schemes/{id}', [SchemeMasterController::class, 'update']);
Route::delete('schemes/{id}', [SchemeMasterController::class, 'destroy']);




Route::get('tax-types', [TaxTypeMasterController::class, 'index']);
Route::post('tax-types', [TaxTypeMasterController::class, 'store']);
Route::get('tax-types/{id}', [TaxTypeMasterController::class, 'show']);
Route::put('tax-types/{id}', [TaxTypeMasterController::class, 'update']);
Route::delete('tax-types/{id}', [TaxTypeMasterController::class, 'destroy']);



Route::get('employee-statuses', [EmployeeStatusMasterController::class, 'index']);
Route::post('employee-statuses', [EmployeeStatusMasterController::class, 'store']);
Route::get('employee-statuses/{id}', [EmployeeStatusMasterController::class, 'show']);
Route::put('employee-statuses/{id}', [EmployeeStatusMasterController::class, 'update']);
Route::delete('employee-statuses/{id}', [EmployeeStatusMasterController::class, 'destroy']);




Route::get('exam-increments', [ExamIncrementMasterController::class, 'index']);
Route::post('exam-increments', [ExamIncrementMasterController::class, 'store']);
Route::get('exam-increments/{id}', [ExamIncrementMasterController::class, 'show']);
Route::put('exam-increments/{id}', [ExamIncrementMasterController::class, 'update']);
Route::delete('exam-increments/{id}', [ExamIncrementMasterController::class, 'destroy']);




/////today
Route::get('/special-duty', [SpecialDutyMasterController::class, 'index']);
Route::post('/special-duty', [SpecialDutyMasterController::class, 'store']);
Route::get('/special-duty/{id}', [SpecialDutyMasterController::class, 'show']);
Route::put('/special-duty/{id}', [SpecialDutyMasterController::class, 'update']);
Route::delete('/special-duty/{id}', [SpecialDutyMasterController::class, 'destroy']);




Route::get('/employee-grade', [EmployeeGradeMasterController::class, 'index']);
Route::post('/employee-grade', [EmployeeGradeMasterController::class, 'store']);
Route::get('/employee-grade/{id}', [EmployeeGradeMasterController::class, 'show']);
Route::put('/employee-grade/{id}', [EmployeeGradeMasterController::class, 'update']);
Route::delete('/employee-grade/{id}', [EmployeeGradeMasterController::class, 'destroy']);







Route::get('/employee-quota', [EmployeeQuotaMasterController::class, 'index']);
Route::post('/employee-quota', [EmployeeQuotaMasterController::class, 'store']);
Route::get('/employee-quota/{id}', [EmployeeQuotaMasterController::class, 'show']);
Route::put('/employee-quota/{id}', [EmployeeQuotaMasterController::class, 'update']);
Route::delete('/employee-quota/{id}', [EmployeeQuotaMasterController::class, 'destroy']);




Route::get('/employee-category', [EmployeeCategoryMasterController::class, 'index']);
Route::post('/employee-category', [EmployeeCategoryMasterController::class, 'store']);
Route::get('/employee-category/{id}', [EmployeeCategoryMasterController::class, 'show']);
Route::put('/employee-category/{id}', [EmployeeCategoryMasterController::class, 'update']);
Route::delete('/employee-category/{id}', [EmployeeCategoryMasterController::class, 'destroy']);


Route::prefix('grant-division-mappings')->group(function () {
    Route::get('/', [GrantDivisionMappingController::class, 'index']);
    Route::post('/', [GrantDivisionMappingController::class, 'store']);
    Route::post('/bulk', [GrantDivisionMappingController::class, 'bulkStore']);
    Route::get('/{id}', [GrantDivisionMappingController::class, 'show']);
    Route::put('/{id}', [GrantDivisionMappingController::class, 'update']);
    Route::delete('/{id}', [GrantDivisionMappingController::class, 'destroy']);
    Route::put('/{id}/restore', [GrantDivisionMappingController::class, 'restore']);
    Route::get('/grant-type/{grantTypeId}', [GrantDivisionMappingController::class, 'byGrantType']);
    Route::get('/department/{departmentId}', [GrantDivisionMappingController::class, 'byDepartment']);
});





Route::get('/employee-type', [EmployeeTypeMasterController::class, 'index']);
Route::post('/employee-type', [EmployeeTypeMasterController::class, 'store']);
Route::get('/employee-type/{id}', [EmployeeTypeMasterController::class, 'show']);
Route::put('/employee-type/{id}', [EmployeeTypeMasterController::class, 'update']);
Route::delete('/employee-type/{id}', [EmployeeTypeMasterController::class, 'destroy']);



Route::get('/education', [EducationMasterController::class, 'index']);
Route::post('/education', [EducationMasterController::class, 'store']);
Route::get('/education/{id}', [EducationMasterController::class, 'show']);
Route::put('/education/{id}', [EducationMasterController::class, 'update']);
Route::delete('/education/{id}', [EducationMasterController::class, 'destroy']);



Route::get('/employee-language', [EmployeeLanguageMasterController::class, 'index']);
Route::post('/employee-language', [EmployeeLanguageMasterController::class, 'store']);
Route::get('/employee-language/{id}', [EmployeeLanguageMasterController::class, 'show']);
Route::put('/employee-language/{id}', [EmployeeLanguageMasterController::class, 'update']);
Route::delete('/employee-language/{id}', [EmployeeLanguageMasterController::class, 'destroy']);





Route::get('/loan-document', [FasLoanDocumentMasterController::class, 'index']);
Route::post('/loan-document', [FasLoanDocumentMasterController::class, 'store']);
Route::get('/loan-document/{id}', [FasLoanDocumentMasterController::class, 'show']);
Route::put('/loan-document/{id}', [FasLoanDocumentMasterController::class, 'update']);
Route::delete('/loan-document/{id}', [FasLoanDocumentMasterController::class, 'destroy']);


// Relationship Master Routes
Route::apiResource('relationship-master', RelationshipMasterController::class);


Route::apiResource('family-info-master', FamilyInfoMasterController::class);
Route::post('/family-info-master/{id}/toggle-status', [FamilyInfoMasterController::class, 'toggleStatus']);
Route::get('/employee-relationships-summary', [FamilyInfoMasterController::class, 'getEmployeeRelationshipsSummary']);

// Qualification Levels Routes
Route::apiResource('qualification-levels', QualificationLevelController::class);

// Streams Routes
Route::apiResource('streams', StreamController::class);

// Recognized By Routes
Route::apiResource('recognized-bies', RecognizedByController::class);


// Grant Category Master Routes
Route::prefix('grant-category-masters')->group(function () {
    Route::get('/', [GrantCategoryMasterController::class, 'index']);
    Route::post('/', [GrantCategoryMasterController::class, 'store']);
    Route::get('/{id}', [GrantCategoryMasterController::class, 'show']);
    Route::put('/{id}', [GrantCategoryMasterController::class, 'update']);
    Route::delete('/{id}', [GrantCategoryMasterController::class, 'destroy']);

    // Soft delete related routes
    Route::get('/trashed/list', [GrantCategoryMasterController::class, 'trashed']);
    Route::post('/{id}/restore', [GrantCategoryMasterController::class, 'restore']);
    Route::delete('/{id}/force', [GrantCategoryMasterController::class, 'forceDelete']);
});

// Main Departments API Routes
Route::apiResource('main-departments', MainDepartmentController::class);
Route::post('main-departments/{id}/toggle-visibility', [MainDepartmentController::class, 'toggleVisibility']);

// Financial Year Master API Routes
Route::apiResource('financial-years', FinancialYearMasterController::class);
Route::get('financial-years/current', [FinancialYearMasterController::class, 'getCurrent']);
Route::post('financial-years/{id}/toggle-budget', [FinancialYearMasterController::class, 'toggleBudget']);
Route::post('financial-years/{id}/toggle-transaction', [FinancialYearMasterController::class, 'toggleTransaction']);


// Standard CRUD routes
Route::apiResource('department-management', DepartmentManagementController::class);

// Custom routes
Route::get('department/{deptId}/users', [DepartmentManagementController::class, 'getUsersByDepartment']);
Route::get('user/{userId}/reporting-hierarchy', [DepartmentManagementController::class, 'getReportingHierarchy']);
Route::get('user/{userId}/subordinates', [DepartmentManagementController::class, 'getSubordinates']);
Route::get('user/{userId}/current-assignments', [DepartmentManagementController::class, 'getUserCurrentAssignments']);
Route::post('department-management/bulk-assign', [DepartmentManagementController::class, 'bulkAssign']);
Route::get('department-management/statistics', [DepartmentManagementController::class, 'getStatistics']);


// Budget Entry Routes
Route::prefix('budget-entries')->group(function () {
    Route::get('/', [BudgetEntryController::class, 'index']);
    Route::get('/status-counts', [BudgetEntryController::class, 'getStatusCounts']);
    Route::post('/', [BudgetEntryController::class, 'store']);
    Route::get('/{id}', [BudgetEntryController::class, 'show']);
    Route::put('/{id}', [BudgetEntryController::class, 'update']);
    Route::delete('/{id}', [BudgetEntryController::class, 'destroy']);

    // Versioning related routes
    Route::get('/{id}/versions', [BudgetEntryController::class, 'getVersions']);
    Route::get('/{id}/current-version', [BudgetEntryController::class, 'getCurrentVersion']);
    Route::get('/{id}/update-history', [BudgetEntryController::class, 'getUpdateHistory']);
    Route::get('/compare/{version1Id}/{version2Id}', [BudgetEntryController::class, 'compareVersions']);
});


// Grant Entry Routes
Route::prefix('grant-entries')->group(function () {
    Route::get('/', [GrantEntryController::class, 'index']);
    Route::get('/status-counts', [GrantEntryController::class, 'getStatusCounts']);
    Route::post('/', [GrantEntryController::class, 'store']);
    Route::get('/{id}', [GrantEntryController::class, 'show']);
    Route::put('/{id}', [GrantEntryController::class, 'update']);
    Route::get('/{id}/version-history', [GrantEntryController::class, 'getVersionHistory']);
});
// Budget Log Book Routes
Route::prefix('budget-logs')->group(function () {
    Route::get('/', [BudgetLogBookController::class, 'index']);
    Route::get('/summary', [BudgetLogBookController::class, 'getSummary']);
    Route::get('/{id}', [BudgetLogBookController::class, 'show']);
    Route::get('/by-budget-entry/{budgId}', [BudgetLogBookController::class, 'getByBudgetEntry']);
    Route::get('/by-status/{status}', [BudgetLogBookController::class, 'getByStatus']);
    Route::get('/by-date-range', [BudgetLogBookController::class, 'getByDateRange']);
    Route::get('/by-user/{userId}', [BudgetLogBookController::class, 'getByUser']);
});


Route::prefix('ledger-dep-mappings')->group(function () {
    Route::get('/', [LedgerDepMappingController::class, 'index']);
    Route::post('/', [LedgerDepMappingController::class, 'store']);
    Route::get('/search', [LedgerDepMappingController::class, 'search']);
    Route::get('/department/{depId}', [LedgerDepMappingController::class, 'byDepartment']);
    Route::get('/ledger/{ledgId}', [LedgerDepMappingController::class, 'byLedger']);
    Route::get('/departments-for-ledger/{ledgId}', [LedgerDepMappingController::class, 'departmentsForLedger']);
    Route::get('/ledgers-for-department/{depId}', [LedgerDepMappingController::class, 'ledgersForDepartment']);
    Route::get('/{id}', [LedgerDepMappingController::class, 'show']);
    Route::put('/{id}', [LedgerDepMappingController::class, 'update']);
    Route::delete('/{id}', [LedgerDepMappingController::class, 'destroy']);
});


Route::apiResource('coa-dep-mappings', CoaDepMappingController::class);

// Additional routes
Route::prefix('coa-dep-mappings')->group(function () {
    Route::get('/by-department/{depId}', [CoaDepMappingController::class, 'byDepartment']);
    Route::get('/by-group/{groupId}', [CoaDepMappingController::class, 'byGroup']);
    Route::post('/{id}/add-groups', [CoaDepMappingController::class, 'addGroups']);
    Route::post('/{id}/remove-groups', [CoaDepMappingController::class, 'removeGroups']);
    Route::get('/groups-for-department/{depId}', [CoaDepMappingController::class, 'groupsForDepartment']);
    Route::get('/departments-for-group/{groupId}', [CoaDepMappingController::class, 'departmentsForGroup']);
});


Route::prefix('new-tender-works')->group(function () {
    // CRUD routes
    Route::get('/', [NewTenderWorkController::class, 'index']);
    Route::get('/all', [NewTenderWorkController::class, 'getAllWithoutPagination']);
    Route::post('/', [NewTenderWorkController::class, 'store']);
    Route::get('/{id}', [NewTenderWorkController::class, 'show']);
    Route::put('/{id}', [NewTenderWorkController::class, 'update']);
    Route::delete('/{id}', [NewTenderWorkController::class, 'destroy']);

    // Additional routes
    Route::post('/{id}/restore', [NewTenderWorkController::class, 'restore']);
    Route::delete('/{id}/force-delete', [NewTenderWorkController::class, 'forceDelete']);
    Route::post('/bulk', [NewTenderWorkController::class, 'bulkStore']);
    Route::get('/active/list', [NewTenderWorkController::class, 'active']);
});

Route::prefix('emdbg-type-masters')->group(function () {
    // CRUD routes
    Route::get('/', [EMDBGTypeMasterController::class, 'index']);
    Route::post('/', [EMDBGTypeMasterController::class, 'store']);
    Route::get('/{id}', [EMDBGTypeMasterController::class, 'show']);
    Route::put('/{id}', [EMDBGTypeMasterController::class, 'update']);
    Route::delete('/{id}', [EMDBGTypeMasterController::class, 'destroy']);

    // Additional routes
    Route::post('/{id}/restore', [EMDBGTypeMasterController::class, 'restore']);
    Route::delete('/{id}/force-delete', [EMDBGTypeMasterController::class, 'forceDelete']);
    Route::post('/bulk', [EMDBGTypeMasterController::class, 'bulkStore']);
    Route::get('/active/list', [EMDBGTypeMasterController::class, 'active']);
    Route::get('/search/advanced', [EMDBGTypeMasterController::class, 'search']);
});

Route::prefix('instrument-masters')->group(function () {
    // CRUD routes
    Route::get('/', [InstrumentMasterController::class, 'index']);
    Route::post('/', [InstrumentMasterController::class, 'store']);
    Route::get('/{id}', [InstrumentMasterController::class, 'show']);
    Route::put('/{id}', [InstrumentMasterController::class, 'update']);
    Route::delete('/{id}', [InstrumentMasterController::class, 'destroy']);

    // Additional routes
    Route::post('/{id}/restore', [InstrumentMasterController::class, 'restore']);
    Route::delete('/{id}/force-delete', [InstrumentMasterController::class, 'forceDelete']);
    Route::post('/bulk', [InstrumentMasterController::class, 'bulkStore']);
    Route::get('/active/list', [InstrumentMasterController::class, 'active']);
    Route::get('/search', [InstrumentMasterController::class, 'search']);
    Route::get('/check/code', [InstrumentMasterController::class, 'checkCode']);
    Route::get('/check/name', [InstrumentMasterController::class, 'checkName']);
});



Route::prefix('vendor-invoice-parameters')->group(function () {
    Route::get('/', [VendorInvoiceParameterController::class, 'index']);
    Route::get('/{id}', [VendorInvoiceParameterController::class, 'show']);
    Route::post('/', [VendorInvoiceParameterController::class, 'store']);
    Route::post('/multiple', [VendorInvoiceParameterController::class, 'storeMultiple']);
    Route::put('/{id}', [VendorInvoiceParameterController::class, 'update']);
    Route::delete('/{id}', [VendorInvoiceParameterController::class, 'destroy']);

    Route::get('/tender-work/{tendWorkId}/date/{date}', [VendorInvoiceParameterController::class, 'getByTenderWorkAndDate']);
    Route::post('/{id}/restore', [VendorInvoiceParameterController::class, 'restore']);
    Route::delete('/{id}/force', [VendorInvoiceParameterController::class, 'forceDelete']);
});

// Document Library Routes
Route::prefix('document-library')->group(function () {
    Route::get('/', [DocumentLibraryController::class, 'index']);
    Route::post('/', [DocumentLibraryController::class, 'store']);
    Route::get('/{id}', [DocumentLibraryController::class, 'show']);
    Route::put('/{id}', [DocumentLibraryController::class, 'update']);
    Route::delete('/{id}', [DocumentLibraryController::class, 'destroy']);
    Route::get('/{id}/download/{fileIndex}', [DocumentLibraryController::class, 'downloadFile']);
});

// Tender Entry Master Routes
Route::prefix('tender-entry')->group(function () {
    Route::get('/', [TenderEntryMasterController::class, 'index']); // With pagination
    Route::get('/all-data', [TenderEntryMasterController::class, 'getAllData']); // Complete data if you still want it
    Route::post('/', [TenderEntryMasterController::class, 'store']);
    Route::get('/{id}', [TenderEntryMasterController::class, 'show']);
    Route::put('/{id}', [TenderEntryMasterController::class, 'update']);
    Route::delete('/{id}', [TenderEntryMasterController::class, 'destroy']);
    Route::get('/statistics', [TenderEntryMasterController::class, 'statistics']);
});

// FaTaxTypeMaster API Routes
Route::prefix('tax-types')->group(function () {
    Route::get('/', [FaTaxTypeMasterController::class, 'index']);
    Route::post('/', [FaTaxTypeMasterController::class, 'store']);
    Route::get('/{id}', [FaTaxTypeMasterController::class, 'show']);
    Route::put('/{id}', [FaTaxTypeMasterController::class, 'update']);
    Route::delete('/{id}', [FaTaxTypeMasterController::class, 'destroy']);
});

Route::prefix('tendor-allocation')->group(function () {
    Route::get('/', [TendorAllocationController::class, 'index']);
    Route::get('/all', [TendorAllocationController::class, 'getAll']); // Without pagination
    Route::post('/', [TendorAllocationController::class, 'store']);
    Route::get('/statistics', [TendorAllocationController::class, 'statistics']);
    Route::get('/by-tender/{tenderEntryId}', [TendorAllocationController::class, 'getByTenderEntry']);
    Route::get('/{id}', [TendorAllocationController::class, 'show']);
    Route::put('/{id}', [TendorAllocationController::class, 'update']);
    Route::delete('/{id}', [TendorAllocationController::class, 'destroy']);
    Route::get('/{id}/documents', [TendorAllocationController::class, 'getDocuments']);
    Route::get('/download/{docLibId}', [TendorAllocationController::class, 'downloadDocument']);
});

// Payment Voucher Routes
Route::prefix('payment-vouchers')->group(function () {

    Route::get('/', [PaymentVoucherController::class, 'index']);
    Route::post('/', [PaymentVoucherController::class, 'store']);
    Route::get('/summary', [PaymentVoucherController::class, 'getSummary']);
    Route::get('/{id}', [PaymentVoucherController::class, 'show']);
    Route::get('/{id}/details', [PaymentVoucherController::class, 'getDetails']);
    Route::put('/{id}', [PaymentVoucherController::class, 'update']);
    Route::delete('/{id}', [PaymentVoucherController::class, 'destroy']);
    Route::post('/{id}/restore', [PaymentVoucherController::class, 'restore']);
    Route::get('/vendor/tender-allocations', [PaymentVoucherController::class, 'getTenderAllocationsByVendor']);

    // New routes for filtering
    Route::get('/branch/tender-entries', [PaymentVoucherController::class, 'getTenderEntriesByBranchWithVendorAllocations']);
    Route::get('/branch/filtered-vendors', [PaymentVoucherController::class, 'getFilteredVendorsByBranch']);
});


Route::prefix('payroll-master')->group(function () {
    Route::get('/', [PayrollMasterController::class, 'index']);
    Route::post('/', [PayrollMasterController::class, 'store']);
    Route::get('/{id}', [PayrollMasterController::class, 'show']);
    Route::put('/{id}', [PayrollMasterController::class, 'update']);
    Route::delete('/{id}', [PayrollMasterController::class, 'destroy']);

    // Additional routes
    Route::get('by-ledger/{ledgerId}', [PayrollMasterController::class, 'getByLedger']);
    Route::get('without-ledger', [PayrollMasterController::class, 'getWithoutLedger']);
    Route::post('bulk-update-ledger', [PayrollMasterController::class, 'bulkUpdateLedger']);
});


// Pay Rate Master Routes
Route::prefix('pay-rate-master')->group(function () {
    Route::get('/', [PayRateMasterController::class, 'index']);
    Route::post('/', [PayRateMasterController::class, 'store']);
    Route::get('/{id}', [PayRateMasterController::class, 'show']);
    Route::put('/{id}', [PayRateMasterController::class, 'update']);
    Route::delete('/{id}', [PayRateMasterController::class, 'destroy']);

    // Additional routes - CHANGED: tender-work से employee-type
    Route::get('by-employee-type/{empTypeId}/{date}', [PayRateMasterController::class, 'getByEmployeeTypeAndDate']);
    Route::post('calculate-total', [PayRateMasterController::class, 'calculateTotalAmount']);
    Route::post('{id}/restore', [PayRateMasterController::class, 'restore']);
    Route::delete('{id}/force-delete', [PayRateMasterController::class, 'forceDelete']);
});


// Pay Commission Routes
Route::prefix('pay-commissions')->group(function () {
    Route::get('/', [PayCommissionMasterController::class, 'index']);
    Route::post('/', [PayCommissionMasterController::class, 'store']);
    Route::get('/{id}', [PayCommissionMasterController::class, 'show']);
    Route::put('/{id}', [PayCommissionMasterController::class, 'update']);
    Route::delete('/{id}', [PayCommissionMasterController::class, 'destroy']);
    Route::get('/{id}/details', [PayCommissionMasterController::class, 'getCommissionDetails']);
});

// Pay Structure Type Routes
Route::prefix('pay-structure-types')->group(function () {
    Route::get('/', [PayStructureTypeMasterController::class, 'index']);
    Route::post('/', [PayStructureTypeMasterController::class, 'store']);
    Route::get('/{id}', [PayStructureTypeMasterController::class, 'show']);
    Route::put('/{id}', [PayStructureTypeMasterController::class, 'update']);
    Route::delete('/{id}', [PayStructureTypeMasterController::class, 'destroy']);
});

// Pay Scale Routes
Route::prefix('pay-scales')->group(function () {
    Route::get('/', [PayScaleMasterController::class, 'index']);
    Route::post('/', [PayScaleMasterController::class, 'store']);
    Route::get('/{id}', [PayScaleMasterController::class, 'show']);
    Route::put('/{id}', [PayScaleMasterController::class, 'update']);
    Route::delete('/{id}', [PayScaleMasterController::class, 'destroy']);
    Route::get('/commission/{commissionId}', [PayScaleMasterController::class, 'getByCommission']);
});

// Pay Band Routes
Route::prefix('pay-bands')->group(function () {
    Route::get('/', [PayBandMasterController::class, 'index']);
    Route::post('/', [PayBandMasterController::class, 'store']);
    Route::get('/{id}', [PayBandMasterController::class, 'show']);
    Route::put('/{id}', [PayBandMasterController::class, 'update']);
    Route::delete('/{id}', [PayBandMasterController::class, 'destroy']);
    Route::get('/commission/{commissionId}', [PayBandMasterController::class, 'getByCommission']);
});

// Grade Pay Routes
Route::prefix('grade-pays')->group(function () {
    Route::get('/', [GradePayMasterController::class, 'index']);
    Route::post('/', [GradePayMasterController::class, 'store']);
    Route::get('/{id}', [GradePayMasterController::class, 'show']);
    Route::put('/{id}', [GradePayMasterController::class, 'update']);
    Route::delete('/{id}', [GradePayMasterController::class, 'destroy']);
    Route::get('/commission/{commissionId}', [GradePayMasterController::class, 'getByCommission']);
});

// Pay Matrix Level Routes
Route::prefix('pay-matrix-levels')->group(function () {
    Route::get('/', [PayMatrixLevelMasterController::class, 'index']);
    Route::post('/', [PayMatrixLevelMasterController::class, 'store']);
    Route::get('/{id}', [PayMatrixLevelMasterController::class, 'show']);
    Route::put('/{id}', [PayMatrixLevelMasterController::class, 'update']);
    Route::delete('/{id}', [PayMatrixLevelMasterController::class, 'destroy']);
    Route::get('/commission/{commissionId}', [PayMatrixLevelMasterController::class, 'getByCommission']);
});

// Pay Matrix Cell Routes
Route::prefix('pay-matrix-cells')->group(function () {
    Route::get('/', [PayMatrixCellMasterController::class, 'index']);
    Route::post('/', [PayMatrixCellMasterController::class, 'store']);
    Route::get('/{id}', [PayMatrixCellMasterController::class, 'show']);
    Route::put('/{id}', [PayMatrixCellMasterController::class, 'update']);
    Route::delete('/{id}', [PayMatrixCellMasterController::class, 'destroy']);
    Route::get('/level/{levelId}', [PayMatrixCellMasterController::class, 'getByLevel']);
});

// Designation Routes
Route::prefix('designations')->group(function () {
    Route::get('/', [DesignationMasterController::class, 'index']);
    Route::post('/', [DesignationMasterController::class, 'store']);
    Route::get('/{id}', [DesignationMasterController::class, 'show']);
    Route::put('/{id}', [DesignationMasterController::class, 'update']);
    Route::delete('/{id}', [DesignationMasterController::class, 'destroy']);
    Route::get('/{id}/pay-history', [DesignationMasterController::class, 'getPayHistory']);
    Route::post('/by-department', [DesignationMasterController::class, 'getByDepartment']);
});

// Designation Pay Mapping Routes
Route::prefix('designation-pay-mappings')->group(function () {
    Route::get('/', [DesignationPayMappingController::class, 'index']);
    Route::post('/', [DesignationPayMappingController::class, 'store']);
    Route::get('/{id}', [DesignationPayMappingController::class, 'show']);
    Route::put('/{id}', [DesignationPayMappingController::class, 'update']);
    Route::delete('/{id}', [DesignationPayMappingController::class, 'destroy']);
    Route::get('/designation/{designationId}', [DesignationPayMappingController::class, 'getByDesignation']);
    Route::get('/commission/{commissionId}', [DesignationPayMappingController::class, 'getByCommission']);
});

// Health check route
Route::get('/health', function () {
    return response()->json([
        'success' => true,
        'message' => 'Municipal Corporation Pay Scale API is running',
        'timestamp' => now()->toDateTimeString(),
        'version' => '1.0.0'
    ]);
});



Route::apiResource('tender-penelty', TenderPeneltyController::class);
Route::apiResource('work-allocation', WorkAllocationController::class);

Route::apiResource('device-logs', DeviceApprovalLogController::class);


Route::apiResource('statuses', StatusController::class);




Route::get('/user-department-mappings', [UserDepartmentMappingController::class, 'index']);

Route::post('/user-department-mappings', [UserDepartmentMappingController::class, 'store']);

Route::get('/user-department-mappings/{id}', [UserDepartmentMappingController::class, 'show']);

Route::put('/user-department-mappings/{id}', [UserDepartmentMappingController::class, 'update']);

Route::delete('/user-department-mappings/{id}', [UserDepartmentMappingController::class, 'destroy']);

Route::get('/department-menu-mappings', [DepartmentMenuMappingController::class, 'index']);

Route::post('/department-menu-mappings', [DepartmentMenuMappingController::class, 'store']);

Route::get('/department-menu-mappings/{id}', [DepartmentMenuMappingController::class, 'show']);

Route::put('/department-menu-mappings/{id}', [DepartmentMenuMappingController::class, 'update']);

Route::delete('/department-menu-mappings/{id}', [DepartmentMenuMappingController::class, 'destroy']);


Route::get('da-master/all', [DAMasterController::class, 'all']);
Route::get('da-master', [DAMasterController::class, 'index']);
Route::post('da-master', [DAMasterController::class, 'store']);
Route::get('da-master/{id}', [DAMasterController::class, 'show']);
Route::put('da-master/{id}', [DAMasterController::class, 'update']);
Route::delete('da-master/{id}', [DAMasterController::class, 'destroy']);



// pagination
Route::get('des-post-book', [DesPostBookController::class, 'index']);
Route::get('des-post-book/all', [DesPostBookController::class, 'all']);
Route::post('des-post-book', [DesPostBookController::class, 'store']);
Route::get('des-post-book/{id}', [DesPostBookController::class, 'show']);
Route::put('des-post-book/{id}', [DesPostBookController::class, 'update']);
Route::delete('des-post-book/{id}', [DesPostBookController::class, 'destroy']);




// pagination
Route::get('tax-slab', [TaxSlabController::class, 'index']);
Route::get('tax-slab/all', [TaxSlabController::class, 'all']);
Route::post('tax-slab', [TaxSlabController::class, 'store']);
Route::get('tax-slab/{id}', [TaxSlabController::class, 'show']);
Route::put('tax-slab/{id}', [TaxSlabController::class, 'update']);
Route::delete('tax-slab/{id}', [TaxSlabController::class, 'destroy']);



Route::apiResource('recruitment-types', RecruitmentTypeController::class);


Route::apiResource('designation-menus', DesignationMenuController::class);
Route::post(
    'designation-menus/{id}/toggle-visibility',
    [DesignationMenuController::class, 'toggleVisibility']
);


Route::prefix('role-permissions')->group(function () {

    Route::get('/', [RolePermissionController::class, 'index']);
    Route::post('/', [RolePermissionController::class, 'store']);

    Route::get('/{id}', [RolePermissionController::class, 'show']);
    Route::put('/{id}', [RolePermissionController::class, 'update']);
    Route::delete('/{id}', [RolePermissionController::class, 'destroy']);

    Route::get('/by-role/{roleId}', [RolePermissionController::class, 'byRole']);
});


Route::apiResource('functiontypestwo', FunctionTypesTwoController::class);
Route::patch('functiontypestwo/{id}/toggle', [FunctionTypesTwoController::class, 'toggleVisibility']);
